/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.pt.ipc.sim.dns.impl;

import com.cisco.pt.IPAddress;
import com.cisco.pt.impl.IPCCall;
import com.cisco.pt.impl.IPCMessageLTV;
import com.cisco.pt.impl.IPCResponseLTV;
import com.cisco.pt.ipc.IPCError;
import com.cisco.pt.ipc.IPCFactory;
import com.cisco.pt.ipc.sim.dns.DNSServerProcess;
import com.cisco.pt.ipc.sim.process.impl.ProcessImpl;
import com.cisco.pt.ptmp.PacketTracerSession;
import com.cisco.pt.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DNSServerProcessImpl
extends ProcessImpl
implements DNSServerProcess {
    public DNSServerProcessImpl(IPCFactory ipcFactory, PacketTracerSession packetTracerSession, IPCMessageLTV accessMessage) {
        super(ipcFactory, packetTracerSession, accessMessage);
    }

    @Override
    public boolean addIpAddress(String hostname, IPAddress ipAddress) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("addIpAddress");
        newCall.addStringParameter(hostname);
        newCall.addIPAddressParameter(ipAddress);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.addIpAddress");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void removeIpAddress(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("removeIpAddress");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public Pair<String, IPAddress> getEntryAt(int index) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEntryAt");
        newCall.addIntParameter(index);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        Pair rawPair = (Pair)returnMessage.getObjectValue();
        Pair<String, IPAddress> answer = new Pair<String, IPAddress>((String)rawPair.getFirst(), (IPAddress)rawPair.getSecond());
        return answer;
    }

    @Override
    public int getEntryCount() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getEntryCount");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.getEntryCount");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public boolean isValidName(String hostname) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isValidName");
        newCall.addStringParameter(hostname);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.isValidName");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setEnable(boolean bEnable) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setEnable");
        newCall.addBoolParameter(bEnable);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public boolean isEnabled() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isEnabled");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.isEnabled");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public void setPortNumber(int num) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("setPortNumber");
        newCall.addIntParameter(num);
        message.addCall(newCall);
        this.sendMessageWithReturn(message);
    }

    @Override
    public int getPortNumber() {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getPortNumber");
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.getPortNumber");
        }
        return returnMessage.getIntValue();
    }

    @Override
    public boolean isDomainNameExisted(String domainName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("isDomainNameExisted");
        newCall.addStringParameter(domainName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            throw new IPCError("Making call on null IPC Object: DNSServerProcessImpl.isDomainNameExisted");
        }
        return returnMessage.getBoolValue();
    }

    @Override
    public IPAddress getIpAddOfDomain(String domainName) {
        IPCMessageLTV message = new IPCMessageLTV();
        message.addCalls(this.accessMessage);
        IPCCall newCall = new IPCCall("getIpAddOfDomain");
        newCall.addStringParameter(domainName);
        message.addCall(newCall);
        IPCResponseLTV returnMessage = this.sendMessageWithReturn(message);
        if (returnMessage == null) {
            return null;
        }
        return (IPAddress)returnMessage.getObjectValue();
    }
}

